import Vue from 'vue'
import VueRouter from 'vue-router'

Vue.use(VueRouter)

const routes = [
  { path: '*', redirect: '/login' },
  /* 登录页面 */
  { path: '/login', component: () => import('@/views/Login.vue') },
  { path: '/login/:examId', name: 'login', component: () => import('@/views/Login.vue') },
  /* 确认信息 */
  { path: '/confirm/:examId', name: 'confirmInfo', component: () => import('@/views/Confirm.vue') },
  /* 考试倒计时 */
  { path: '/countdown/:examId', name: 'examTime', component: () => import('@/views/Countdown.vue') },
  /* 答题 */
  { path: '/exam/:examId', name: 'examAnswer', component: () => import('@/views/Exam.vue') },
  /* 结束考试 */
  { path: '/finish/:examId', name: 'examEnd', component: () => import('@/views/Finish.vue') }
]

const router = new VueRouter({
  mode: 'history',
  routes
})

export default router
