import Vue from 'vue'
import Vuex from 'vuex'
import router from '@/router'

Vue.use(Vuex)

let studentInfo = {}
let examInfo = {}
try {
  const parsed = JSON.parse(window.localStorage.getItem('studentInfo')) || {}
  studentInfo = location.pathname.includes(parsed.examId) ? parsed : {}
  // examInfo = JSON.parse(window.localStorage.getItem('examInfo')) || {}
} catch (error) {
  console.log(error)
}

export default new Vuex.Store({
  state: {
    studentInfo,
    examInfo,
  },
  mutations: {
    setExamInfo(state, info) {
      state.examInfo = info
      window.localStorage.setItem('examInfo', JSON.stringify(info))
    },
    setStudentInfo(state, info) {
      info.examId = router.currentRoute.params.examId
      state.studentInfo = info
      window.localStorage.setItem('studentInfo', JSON.stringify(info))
    },
  },
})
