import fs from 'fs'
import path from 'path'
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue2'
import checker from 'vite-plugin-checker'

export default defineConfig(({ mode }) => ({
  base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/exam/' : '/',
  plugins: [vue(), checker({ eslint: { lintCommand: 'eslint "./src/**/*.{vue,js,jsx,ts,tsx}"' } })],
  server: {
    open: true,
    host: 'dev.ezijing.com',
    https: {
      key: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com-key.pem')),
      cert: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com.pem'))
    },
    proxy: {
      '/api': 'https://exam-show.ezijing.com'
    }
  },
  build: {
    outDir: 'client-dist'
  },
  resolve: {
    alias: [{ find: '@', replacement: path.resolve(__dirname, 'src') }]
  },
  css: {
    // 禁用SASS警告提醒
    preprocessorOptions: { scss: { quietDeps: true, charset: false } }
  }
}))
