import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from '@/store'
import modules from './modules'
// 公共css
import '@/assets/css/base.css'
import beforeEnter from '@/utils/beforeEnter'

// Element-UI
import ElementUI from 'element-ui'
import '@/assets/theme/style.scss'
Vue.use(ElementUI)

// 注册模块
modules({ router, store })

router.beforeEach(beforeEnter)

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
