import httpRequest from '@/utils/axios'
// 获取项目列表
export function getProjectList(data) {
  return httpRequest.get('/api/finance/v1/projects/list', data)
}
// 获取支付过滤条件
export function getCondition(data) {
  return httpRequest.get('/api/finance/v1/payments/condition', data)
}
// 获取支付列表
export function getPayList(data) {
  return httpRequest.get('/api/finance/v1/payments/list', data)
}
// 支付列表下载
export function download(data) {
  return httpRequest.get('/api/finance//v1/payments/download', data)
}

// 是否允许开具发票
export function allowCreate(data) {
  return httpRequest.post('/api/finance/v1/payments/update-can-invoice', data)
}
// 退费
export function drawBack(data) {
  return httpRequest.post('/api/finance/v1/payments/drawback', data)
}
// 获取表头
export function getTableTitle(data) {
  return httpRequest.get('/api/finance/v1/payments/title-list', data)
}
// 设置表头
export function updateTableTitle(data) {
  return httpRequest.get('/api/finance/v1/payments/update-title', data)
}
// 查看支付详情
export function payDetail(data) {
  return httpRequest.get('/api/finance/v1/payments/details', data)
}
// 开具发票
export function createNewTicket(data) {
  return httpRequest.get('/api/finance/v1/invoices/create', data)
}
// 作废发票
export function cancelTicket(data) {
  return httpRequest.post('/api/finance/v1/invoices/cancel', data)
}
// 确认（取消）单条缴费到账
export function payConfirm(data) {
  return httpRequest.get('/api/finance/v1/payments/details-confirm', data)
}
// 渠道列表
export function getChannelList(data) {
  return httpRequest.get('/api/finance/v1/channels/list', data)
}
// // 申请状态
// export function getApplyStatusList(data) { // 待修改
//   return httpRequest.get('/api/finance/v1/channels/list', data)
// }
// 费用类型
export function getExpenseList(data) { // 待修改
  return httpRequest.get('/api/finance/v1/channels/list', data)
}
