import httpRequest from '@/utils/axios'
// 获取项目列表
export function getProjectList(params) {
  return httpRequest.get('/api/finance/v1/projects/list', { params })
}
// 获取支付过滤条件
export function getCondition(params) {
  return httpRequest.get('/api/finance/v1/payments/condition', { params })
}
// 获取支付列表
export function getPayList(data) {
  return httpRequest.get('/api/finance/v1/payments/list', data)
}
// 查看支付详情
export function payDetail(params) {
  return httpRequest.get('/api/finance/v1/payments/details', { params })
}
// 支付列表下载
export function download(data) {
  return httpRequest.get('/api/finance/v1/payments/download', data)
}
// 是否允许开具发票
export function allowCreate(data) {
  return httpRequest.post('/api/finance/v1/payments/update-can-invoice', data)
}
// 退费
export function drawBack(data) {
  return httpRequest.post('/api/finance/v1/payments/drawback', data)
}
// 获取表头
export function getTableTitle(data) {
  return httpRequest.get('/api/finance/v1/payments/title-list', data)
}
// 设置表头
export function updateTableTitle(data) {
  return httpRequest.get('/api/finance/v1/payments/update-title', data)
}
// 开具发票
export function createNewTicket(data) {
  return httpRequest.get('/api/finance/v1/invoices/create', data)
}
// 作废发票
export function cancelTicket(data) {
  return httpRequest.post('/api/finance/v1/invoices/cancel', data)
}
// 确认（取消）单条缴费到账
export function payConfirm(data) {
  return httpRequest.post('/api/finance/v1/payments/details-confirm', data)
}
