import httpRequest from '@/utils/axios'

/**
 * 获取商品列表
 */
export function getInvoiceList(params) {
  return httpRequest.get('/api/finance/v1/invoices/list', { params }).then({})
}

// 获取支付过滤条件
export function getCondition(params) {
  return httpRequest.get('/api/finance/v1/payments/condition', { params })
}

// 分配发票跟进人
export function assignSales(data) {
  return httpRequest.post('/api/finance/v1/invoices/assign-sales', data, {})
}

// 发票充值
export function deposit() {
  return httpRequest.post('/api/finance/v1/invoices/deposit')
}

// 下载发票列表
export function downloadInvoices(params) {
  return httpRequest.get('/api/finance/v1/invoices/download', { params, responseType: 'blob' })
}
