import httpRequest from '@/utils/axios'
// 获取项目列表
export function getProjectList(params) {
  return httpRequest.get('/api/finance/v1/projects/list', { params })
}
// 获取支付过滤条件
export function getCondition(params) {
  return httpRequest.get('/api/finance/v1/payments/condition', { params })
}
// 获取支付列表
export function getPayList(params) {
  return httpRequest.get('/api/finance/v1/payments/list', { params })
}
// 查看支付详情
export function payDetail(params) {
  return httpRequest.get('/api/finance/v1/payments/details', { params })
}
// 支付列表下载
export function download(params) {
  return httpRequest.get('/api/finance/v1/payments/download', { params, responseType: 'blob' })
}

// 是否允许开具发票
export function allowCreate(data) {
  return httpRequest.post('/api/finance/v1/payments/update-can-invoice', data)
}
// 退费
export function drawBack(data) {
  return httpRequest.post('/api/finance/v1/payments/drawback', data)
}
// 获取表头
export function getTableTitle(params) {
  return httpRequest.get('/api/finance/v1/payments/title-list', { params })
}
// 设置表头
export function updateTableTitle(params) {
  return httpRequest.get('/api/finance/v1/payments/update-title', { params })
}
// 开具发票
export function createNewTicket(data) {
  return httpRequest.post('/api/finance/v1/invoices/create', data)
}
// 作废发票
export function cancelTicket(data) {
  return httpRequest.post('/api/finance/v1/invoices/cancel', data)
}
// 确认（取消）单条缴费到账
export function payConfirm(data) {
  return httpRequest.post('/api/finance/v1/payments/details-confirm', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
// 确认足额支付
export function confirmPayDetail(data) {
  return httpRequest.post('/api/finance/v1/payments/undo-confirm', data)
}
// 取消足额支付
export function cancelPayDetail(data) {
  return httpRequest.post('/api/finance/v1/payments/undo-confirm', data)
}
// 取消单条缴费到账
export function payCancel(data) {
  return httpRequest.post('/api/finance/v1/payments/undo-details-confirm', data)
}
// 获取开票历史
export function historyInfo(data) {
  return httpRequest.post('/api/finance/v1/invoices/history', data)
}
