import { getSignature, uploadFile } from '@/api/base'
import md5 from 'blueimp-md5'

export default function (blobInfo, succFun, failFun) {
  const file = blobInfo.blob()
  getSignature()
    .then(response => {
      const prefix = 'upload/admin/'
      const fileName = file.name
      const key = prefix + md5(fileName + new Date().getTime()) + fileName.substr(fileName.lastIndexOf('.'))
      const { accessid, policy, signature, host } = response
      const data = { key, OSSAccessKeyId: accessid, policy, signature, success_action_status: '200', file }
      const fileUrl = `${host}/${key}`
      uploadFile(data)
        .then(() => {
          succFun(fileUrl)
        })
        .catch(() => {
          failFun('上传失败')
        })
    })
    .catch(response => {
      failFun('获取Signature失败')
    })
}
