import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export function uploadFile(data) {
  return httpRequest.post('https://webapp-pub.oss-cn-beijing.aliyuncs.com', data, {
    withCredentials: false,
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/**
 * 获取权限列表
 */
export function getPermissions(params) {
  return httpRequest.get('/api/permissions/api/v1/user/permissions', { params })
}

/**
 * 获取所有项目列表
 */
export function getAllProjects(params) {
  return httpRequest.get('/api/xedu/admin/v2/project/all', { params })
}

// 搜索紫荆用户
export function userSearch(params) {
  return httpRequest.get('/api/permissions/admin/v1/system/search-sso-users', { params })
}
