import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import modules from './modules'

// 公共css
import './assets/css/base.css'
// Element-UI
import ElementUI from 'element-ui'
import './assets/theme/style.scss'
// 公共组件
import AppCard from './components/base/AppCard.vue'
import AppList from './components/base/AppList.vue'

// 注册element-ui组件
Vue.use(ElementUI, { size: 'small' })

// 注册公共组件
Vue.component('app-card', AppCard)
Vue.component('app-list', AppList)

// 注册模块
modules({ router, store })

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
