import httpRequest from '@/utils/axios'

/**
 * 获取权限列表
 */
export function getPermissionList(params) {
  return httpRequest.get('/api/xedu/admin/v3/permissions', { params })
}

/**
 * 获取权限详情
 */
export function getPermission(params) {
  return httpRequest.get(`/api/xedu/admin/v3/permission/${params.id}`, { params })
}

/**
 * 创建权限
 */
export function createPermission(data) {
  return httpRequest.post('/api/xedu/admin/v3/permission', data)
}

/**
 * 修改权限
 */
export function updatePermission(data) {
  return httpRequest.put(`/api/xedu/admin/v3/permission/${data.id}`, data)
}

/**
 * 删除权限
 */
export function deletePermission(data) {
  return httpRequest.delete(`/api/xedu/admin/v3/permission/${data.id}`, data)
}

/**
 * 复制权限
 */
export function clonePermission(data) {
  return httpRequest.post('/api/xedu/admin/v3/permission/copy', data)
}
