import httpRequest from '@/utils/axios'

/**
 * 获取项目列表
 */
export function getProjectList(params) {
  return httpRequest.get('/api/xedu/admin/v2/projects', { params })
}

/**
 * 获取项目详情
 */
export function getProject(params) {
  return httpRequest.get(`/api/xedu/admin/v2/${params.id}/project`, { params })
}

/**
 * 创建项目
 */
export function createProject(data) {
  return httpRequest.post('/api/xedu/admin/v2/project', data)
}

/**
 * 修改项目
 */
export function updateProject(data) {
  return httpRequest.put(`/api/xedu/admin/v2/${data.id}/project`, data)
}

/**
 * 修改项目状态
 */
export function updateProjectStatus(data) {
  return httpRequest.post(`/api/xedu/admin/v2/project/${data.id}/status`, data)
}
/**
 * 删除项目
 */
export function deleteProject(data) {
  return httpRequest.delete(`/api/xedu/admin/v2/${data.id}/project`, data)
}

/**
 * 初始化机构用户角色
 */
export function initUserRole(data) {
  return httpRequest.post('/api/xedu/admin/v3/role/init-user-role', data)
}
