import fs from 'fs'
import path from 'path'
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue2'
import checker from 'vite-plugin-checker'

export default defineConfig(({ mode }) => {
  return {
    base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/x-school-admin/' : '/',
    plugins: [vue(), checker({ eslint: { lintCommand: 'eslint "./src/**/*.{vue,js,jsx,ts,tsx}"' } })],
    server: {
      open: true,
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.join(__dirname, './https/ezijing.com.key')),
        cert: fs.readFileSync(path.join(__dirname, './https/ezijing.com.pem'))
      },
      proxy: {
        '/api': 'https://project-center.ezijing.com'
      }
    },
    resolve: {
      alias: [
        {
          find: '@',
          replacement: path.resolve(__dirname, 'src')
        }
      ]
    },
    css: {
      // 禁用SASS警告提醒
      preprocessorOptions: { scss: { quietDeps: true, charset: false } }
    }
  }
})
