import httpRequest from '@/utils/axios'

/**
 * 获取角色列表
 */
export function getRoleList(params) {
  return httpRequest.get('/api/xedu/admin/v3/roles', { params })
}

/**
 * 获取角色详情
 */
export function getRole(params) {
  return httpRequest.get(`/api/xedu/admin/v3/role/${params.id}`, { params })
}

/**
 * 创建角色
 */
export function createRole(data) {
  return httpRequest.post('/api/xedu/admin/v3/role', data)
}

/**
 * 修改角色
 */
export function updateRole(data) {
  return httpRequest.put(`/api/xedu/admin/v3/role/${data.id}`, data)
}

/**
 * 删除角色
 */
export function deleteRole(data) {
  return httpRequest.delete(`/api/xedu/admin/v3/role/${data.id}`, data)
}

/**
 * 获取权限列表
 */
export function getPermissionList(params) {
  return httpRequest.get('/api/xedu/admin/v3/permissions', { params })
}
/**
 * 获取角色所有权限
 */
export function getRolePermissions(params) {
  return httpRequest.get(`/api/xedu/admin/v3/assign/${params.role_id}/permissions`, { params })
}
/**
 * 更新角色权限
 */
export function updateRolePermissions(data) {
  return httpRequest.post('/api/xedu/admin/v3/assign/permissions-to-role', data)
}
/**
 * 获取课程列表
 */
export function getCourseList(params) {
  return httpRequest.get(`/api/xedu/admin/v2/courses/${params.project_tag}`, { params })
}
