import httpRequest from '@/utils/axios'

/**
 * 获取机构列表
 */
export function getOrgList(params) {
  return httpRequest.get('/api/xedu/admin/v2/organizations', { params })
}

/**
 * 获取机构详情
 */
export function getOrg(params) {
  return httpRequest.get(`/api/xedu/admin/v2/organization/${params.id}`, { params })
}

/**
 * 创建机构
 */
export function createOrg(data) {
  return httpRequest.post('/api/xedu/admin/v2/organization', data)
}

/**
 * 修改机构
 */
export function updateOrg(data) {
  return httpRequest.put(`/api/xedu/admin/v2/organization/${data.id}`, data)
}

/**
 * 删除机构
 */
export function deleteOrg(data) {
  return httpRequest.delete(`/api/xedu/admin/v2/organization/${data.id}`, data)
}

/**
 * 获取角色列表
 */
export function getRoleList(params) {
  return httpRequest.get(`/api/xedu/admin/v3/role/all/${params.project_id}`, { params })
}

/**
 * 获取所有机构列表
 */
export function getAllOrgList(params) {
  return httpRequest.get(`/api/xedu/admin/v2/organization/children/${params.project_id}`, { params })
}

/**
 *
 * 用户Start
 * */

/**
 * 获取机构用户列表
 */
export function getOrgUserList(params) {
  return httpRequest.get('/api/xedu/admin/v3/org/users', { params })
}
/**
 * 创建机构用户
 */
export function createOrgUser(data) {
  return httpRequest.post('/api/xedu/admin/v3/org/users', data)
}
/**
 * 修改机构用户
 */
export function updateOrgUser(data) {
  return httpRequest.put(`/api/xedu/admin/v3/org/user/${data.id}`, data)
}
/**
 * 删除机构用户
 */
export function deleteOrgUser(data) {
  return httpRequest.post('/api/xedu/admin/v3/org/user/batch-delete', data)
}
/**
 *
 * 用户End
 * */
