import Vue from 'vue'
import Vuex from 'vuex'
import { getUser, logout, getPermissions, getAllProjects } from '@/api/base'

Vue.use(Vuex)

const store = new Vuex.Store({
  state: {
    user: {},
    permissions: [], // 权限列表
    projects: [], // 项目列表
    activeProject: {} // 当前激活的项目
  },
  mutations: {
    setUser(state, user) {
      state.user = user
    },
    setPermissions(state, permissions) {
      state.permissions = permissions
    },
    setProjects(state, projects) {
      state.projects = projects
    },
    setActiveProjedct(state, project = {}) {
      state.activeProject = project
      localStorage.setItem('project_id', project.id || '')
    }
  },
  actions: {
    // 获取所有项目列表
    getAllProjects({ commit }) {
      getAllProjects().then(res => {
        const projects = res.data
        const localProjectId = localStorage.getItem('project_id')
        // 当前激活的项目
        if (localProjectId) {
          const activeProject = projects.find(item => item.id === localProjectId) || {}
          commit('setActiveProjedct', activeProject)
        }
        // 所有项目列表
        commit('setProjects', projects)
      })
    },
    // 获取权限列表
    getPermissions({ commit }) {
      getPermissions({ type: 2 }).then(res => {
        if (res.data && res.data.items) {
          commit('setPermissions', res.data.items)
        }
      })
    },
    // 获取用户信息
    getUser({ commit }) {
      getUser().then(response => {
        commit('setUser', response)
      })
    },
    // 退出登录
    logout({ commit }) {
      return logout().then(response => {
        commit('setUser', {})
        return response
      })
    },
    async checkLogin({ commit }) {
      const isLogin = await getUser()
        .then(response => {
          if (response.code === 0) {
            commit('setUser', response.data)
            return true
          } else {
            commit('setUser', {})
            return false
          }
        })
        .catch(() => {
          commit('setUser', {})
          return false
        })
      return isLogin
    }
  }
})
const localProjectId = localStorage.getItem('project_id')
// 当前激活的项目
if (localProjectId) {
  store.commit('setActiveProjedct', { id: localProjectId })
}

// 初始化获取权限列表
store.dispatch('getPermissions')
// 初始化获取项目列表
store.dispatch('getAllProjects')

export default store
