import { createApp } from 'vue'
import { createPinia } from 'pinia'
import App from './App.vue'
import router from './router'
import Vant from 'vant'
import 'vant/lib/index.css'

// 公共组件
import AppCard from '@/components/base/AppCard.vue'
import AppContainer from '@/components/base/AppContainer.vue'
import Avatar from '@/components/Avatar.vue'

import modules from './modules'

// import useWXShare from '@/utils/wx'

const app = createApp(App)
// 注册公共组件
app.component('AppCard', AppCard).component('AppContainer', AppContainer).component('Avatar', Avatar)
// 注册模块
modules({ router })

app.use(createPinia())
app.use(router)
app.use(Vant)

app.mount('#app')

// useWXShare()
