import { createRouter, createWebHistory } from 'vue-router'
import { useUserStore } from '@/stores/user'

const router = createRouter({
  history: createWebHistory(),
  routes: [{ path: '/:pathMatch(.*)*', redirect: '/' }]
})

router.beforeEach(async (to, from, next) => {
  const user = useUserStore()
  if (to.meta.requireLogin) {
    try {
      await user.getUser()
    } catch (error) {
      console.log(error)
    }
    if (!user.isLogin) {
      location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(location.href)}`
    }
  }
  next()
})

export default router
