import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/psp/v1/my/info')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export function uploadFile(data: object) {
  return httpRequest.post('https://webapp-pub.oss-cn-beijing.aliyuncs.com', data, {
    withCredentials: false,
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 获取导学视频详情
export function getVideoView(params: { id: string }) {
  return httpRequest.get('/api/psp/v1/admission/video-view', { params })
}
// 获取推荐课程列表
export function getRecommendCourse(params?: { page_size?: string; page?: string; category:string }) {
  return httpRequest.get('/api/psp/v2/learning/course-list', { params })
}
// 获取导师列表
export function getTeacherList(params?: { page_size?: string; page?: string; type?: string }) {
  return httpRequest.get('/api/psp/v1/lecturer/list', { params })
}
