import httpRequest from '@/utils/axios'

// 获取消息列表
export function getMessageList(params?: { page_size?: number; page?: number }) {
  return httpRequest.get('/api/psp/v1/message/audit-list', { params })
}

// 获取文档数据
export function getDocView(params: { id: string }) {
  return httpRequest.get('/api/psp/v1/message/doc-view', { params })
}

// 团队成员审核
export function teamAudit(data: { id: string; status: '1' | '4'; audit_comment?: string }) {
  return httpRequest.post('/api/psp/v1/message/audit', data)
}
