import httpRequest from '@/utils/axios'

// 获取首页数据
export function getHomeData() {
  return httpRequest.get('/api/psp/v2/index/index')
}
// 获取导学视频列表
export function getVideoList(params?: { page_size?: number; page?: number }) {
  return httpRequest.get('/api/psp/v1/learning/video-list', { params })
}

// 获取导学视频详情
export function getVideoView(params: { id: string }) {
  return httpRequest.get('/api/psp/v1/learning/video-view', { params })
}

// 获取课程列表
export function getCourseList(params?: { page_size?: number; page?: number }) {
  return httpRequest.get('/api/psp/v1/learning/course-list', { params })
}

// 陪伴问答评论
export function createQuestionComment(data: { question_id: string; to_comment_id?: string; content: string }) {
  return httpRequest.post('/api/psp/v1/question/create-comment', data)
}
