import httpRequest from '@/utils/axios'

// 获取我的信息
export function getMyInfo() {
  return httpRequest.get('/api/psp/v1/my/info')
}

// 获取学习
export function getStudyInfo() {
  return httpRequest.get('/api/psp/v2/my/info')
}

// 获取课程列表
export function getCourseList(params?: { page_size?: number; page?: number }) {
  return httpRequest.get('/api/psp/v1/learning/course-list', { params })
}

// 持证人权益-上传头像
export function updateAvatar(data: { avatar: string }) {
  return httpRequest.post('/api/psp/v1/welfare/avatar', data)
}
