import httpRequest from './axios'

export default function useWXShare(data) {
  const shareData = Object.assign(
    {
      title: 'FI私享星球',
      desc: '玩转【系统知识】  让每个人都有改变的能力',
      link: location.href,
      imgUrl: 'https://webapp-pub.ezijing.com/upload/admin/8348532dc17af54ed9d2279ca12b055a.png'
    },
    data
  )

  const updateShareData = () => {
    wx.updateAppMessageShareData({
      title: shareData.title,
      desc: shareData.desc,
      link: shareData.link,
      imgUrl: shareData.imgUrl
    })

    wx.updateTimelineShareData({
      title: shareData.title,
      link: shareData.link,
      imgUrl: shareData.imgUrl
    })
  }

  httpRequest
    .post('https://node-server.ezijing.com/share/getsignature', {
      appId: 'wx451c01d40d090d7a',
      url: location.href.split('#').pop()
    })
    .then(result => {
      wx.config({
        debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
        appId: 'wx451c01d40d090d7a', // 必填，公众号的唯一标识
        timestamp: result.timestamp, // 必填，生成签名的时间戳
        nonceStr: result.noncestr, // 必填，生成签名的随机串
        signature: result.token, // 必填，签名
        jsApiList: ['updateAppMessageShareData', 'updateTimelineShareData'] // 必填，需要使用的JS接口列表
      })
      wx.ready(updateShareData)
    })
}
