import type { IVideoItem, ICourseItem, ITeam } from '@/types'

export interface HomeInfo {
  banner: IBanner[]
  course: ICourse[]
  lecture: ILecture[]
  // admission_guide_docs: IDocItem[]
  // admission_guide_videos: IVideoItem[]
  // learning_map_docs: IDocItem[]
  // exam_strategy_docs: IDocItem[]
  // questions: { total: number; list: Record<string, any>[] }
  // ranking: ITeam[]
  // hot_message_docs: INews[]
}

export interface ILecture {
  id: string
  lecturer_name: string
  lecturer_title: string
  lecturer_office: string
}

export interface ICourse {
  id: string
  category_name: string
  category: string
  is_free_name: string
  is_free: string
  prices: string
  times: string
}

export interface IBanner {
  id: string
  title: string
  type: string
  pv: string
  cover_page: string
  url: string
}

export interface IDocItem {
  id: string
  title: string
  pv: string
  desc_type: '1' | '2'
  url: string
}
export interface INews {
  created_time: string
  desc_type: string
  desc_type_name: string
  file: string
  id: string
  picture: string
  pv: string
  title: string
  type: string
  type_name: string
  url: string
}

export { IVideoItem, ICourseItem, ITeam }