import type { PayOrder, Order } from '../types'
import * as api from '../api'
import { useUserStore } from '@/stores/user'
// import { useShopStore } from '@/stores/shop'
import { useStorage } from '@vueuse/core'
import { useDevice } from '@/composables/useDevice'

// https://h5-shop.ezijing.com/buy?shop_id=7238733808088907776&spu_id=7238739080446476288

const { wechat } = useDevice()

export function usePay() {
  const route = useRoute()
  const userStore = useUserStore()
  // const shopStore = useShopStore()
  // 订单信息
  const order = ref<Order>()
  // 支付的订单信息
  const payOrder = ref<PayOrder>()

  const openId = useStorage('openId', '')

  let redirectURL = $ref(`${location.origin}/shop/result?id=${route.query.id}`)


  // 支付
  async function pay(options = {}, data: any) {
    redirectURL = `${location.origin}/shop/result?id=${route.query.id}&type=${data.type}&am=${data.amount}`
    // 默认参数
    const defaultParams: Record<string, any> = reactive({
      shop_id: data.shop_id,
      spu_id: data.spu_id,
      sku_id: data.sku_id,
      buy_count: '1',
      redirect_url: redirectURL,
      notify_url: data.nUrl
    })
    const params = Object.assign(defaultParams, options)
    if (wechat.value && params.payment_method === '4') {
      params.payment_method = '3'
      params.open_id = await getOpenId()
    }

    // 创建订单
    await createOrder(params)
    if (!payOrder.value) return

    // 网页支付，直接唤起对应支付网页
    if (params.payment_method === '12') {
      location.href = payOrder.value.payment_url
      return
    }
    // 微信h5支付
    if (params.payment_method === '4') {
      const paymentUrl = `${payOrder.value.payment_url}&redirect_url=${encodeURIComponent(
        `https://pages.ezijing.com/base/auth.html?redirect_uri=${encodeURIComponent(redirectURL)}`
      )}`
      location.href = `https://pages.ezijing.com/base/pay.html?payment_url=${encodeURIComponent(
        paymentUrl
      )}&redirect_url=${redirectURL}`
      return
    }
    // 微信JS支付
    if (params.payment_method === '3') {
      wxJSPay()
    }
    // 检测订单信息
    checkOrder()
  }

  // 创建订单
  async function createOrder(params: any) {
    const res: any = await api.createOrder(params)
    payOrder.value = res
    localStorage.setItem('order_detail_id', res.order_detail_id)
    await getOrder()
    return res
  }

  // 获取订单信息
  async function getOrder() {
    if (!payOrder.value) return
    const res = await api.getOrderList({ order_detail_id: payOrder.value.order_detail_id })
    const currentOrder = res.data[0]
    order.value = currentOrder
    return currentOrder
  }

  // 检测订单状态
  let timer = 0
  async function checkOrder() {
    if (!payOrder.value) return
    timer && clearInterval(timer)
    timer = setInterval(async () => {
      const currentOrder = await getOrder()
      if (currentOrder?.order_status === '4') clearInterval(timer)
    }, 1000)
  }

  // onUnmounted(() => {
  //   timer && clearInterval(timer)
  // })

  // 微信支付相关
  // 获取code
  function getCode() {
    const href = location.href.includes('?') ? `${location.href}&is_pay=true` : `${location.href}?is_pay=true`
    const redirectURI = `https://pages.ezijing.com/base/auth.html?redirect_uri=${encodeURIComponent(href)}`
    location.href = `https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx451c01d40d090d7a&redirect_uri=${redirectURI}&response_type=code&scope=snsapi_base`
  }

  // 获取openId
  async function getOpenId() {
    if (openId.value) return openId.value
    const code = route.query.code || getCode()
    return api
      .getOpenId({ code, identity: 'ezijing' })
      .then((res: any) => {
        openId.value = res.openid
        return res.data.openid
      })
      .catch(getCode)
  }

  function wxJSPay() {
    if (!payOrder.value?.payment_more_info) {
      alert('订单创建错误')
      return
    }
    location.href = `https://pages.ezijing.com/base/pay.html?payment_more_info=${payOrder.value.payment_more_info}&redirect_url=${redirectURL}`
    // const payInfo: any = JSON.parse(payOrder.value.payment_more_info)
    // ;(window as any).WeixinJSBridge?.invoke('getBrandWCPayRequest', payInfo, (res: any) => {
    //   console.log(res)
    // })
  }

  return { order, payOrder, pay }
}
