import httpRequest from '@/utils/axios'

/**
 * 创建订单
 * */
export function createOrder(data?: any) {
  return httpRequest.post('https://shop-show-pc.ezijing.com/api/shop/order/add', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

/**
 * 获取订单
 * */
export function getOrderList(data?: any) {
  return httpRequest.post('https://shop-show-pc.ezijing.com/api/shop/order/search', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

/**
 * 获取用户OpenId
 * */
export function getOpenId(data?: any) {
  return httpRequest.post('https://shop-show-pc.ezijing.com/api/usercenter/v1/wechat/get-openid', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}

export function getCourseDetail(params: { id: string }) {
  return httpRequest.get('/api/psp/v2/learning/course-view', { params })
}