import { defineStore } from 'pinia'
import { getUser, logout } from '@/api/base'

import type { IUserState } from '@/types'

interface State {
  user: IUserState | null
}

export const useUserStore = defineStore({
  id: 'user',
  state: (): State => {
    return {
      user: null
    }
  },
  getters: {
    isLogin: state => !!state.user
  },
  actions: {
    async getUser() {
      const res = await getUser()
      this.user = res.data.info
    },
    async logout() {
      await logout()
      this.user = null
    }
  }
})
