import httpRequest from '@/utils/axios'

// 获取资料消息列表
// 类型（1:入学指南，2：学习地图，3：考试攻略，4：消息）
export function getShareList(params?: { title?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/share/index', { params })
}

// 创建资料
export function createShare(data: { title: string; content: string[]; weight?: string }) {
  return httpRequest.post('/api/psp/backend/share/create', data)
}

// 更新资料
export function updateShare(data: { id: string; title: string; content: string[]; weight?: string }) {
  return httpRequest.post('/api/psp/backend/share/update', data)
}

// 获取资料详情
export function getShare(params: { id: string }) {
  return httpRequest.get('/api/psp/backend/share/view', { params })
}

// 删除资料
export function deleteShare(data: { id: string }) {
  return httpRequest.post('/api/psp/backend/share/delete', data)
}
