import httpRequest from '@/utils/axios'

// 获取审核列表
// 类型（1:入学指南，2：学习地图，3：考试攻略，4：消息）
export function getAuditList(params?: { type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/auditing/index', { params })
}

// 获取审核详情
export function getAudit(params: { id: string; page_size?: number; page?: number }) {
  return httpRequest.get('/api/psp/backend/auditing/view', { params })
}

// 提交审核
export function submitAudit(data: { tab: string; id: string; status: number; audit_comment?: string }) {
  return httpRequest.post('/api/psp/backend/auditing/audit', data)
}
