import httpRequest from '@/utils/axios'

// 获取课程列表
export function getCourseList(params?: { name?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/course/index', { params })
}

// 更新课程信息
export function updateCourse(data: { id?: string; weight?: string; status?: string }) {
  return httpRequest.post('/api/psp/backend/course/update', data)
}

// 同步课程
export function syncCourse() {
  return httpRequest.get('/api/psp/backend/course/sync')
}

// 获取课程学员列表
export function getCourseStudentList(params: { course_id: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend-v2/course/students', { params })
}
