import httpRequest from '@/utils/axios'

// 获取导师列表
export function getLecturerList(params?: { name?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/lecturer/index', { params })
}

// 创建导师
export function createLecturer(data: {
  name: string
  avatar: string
  type: string
  title: string
  office: string
  weight?: string
}) {
  return httpRequest.post('/api/psp/backend/lecturer/create', data)
}

// 更新导师
export function updateLecturer(data: {
  id: string
  name: string
  avatar: string
  type: string
  title: string
  office: string
  weight?: string
}) {
  return httpRequest.post('/api/psp/backend/lecturer/update', data)
}

// 获取导师详情
export function getLecturer(params: { id: string }) {
  return httpRequest.get('/api/psp/backend/lecturer/view', { params })
}

// 删除导师
export function deleteLecturer(data: { id: string }) {
  return httpRequest.post('/api/psp/backend/lecturer/delete', data)
}
