import httpRequest from '@/utils/axios'

// 获取学员列表
export function getUserList(params?: { name?: string; mobile?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/user/index', { params })
}

// 获取学员详情
export function getUser(params: { id: string }) {
  return httpRequest.get('/api/psp/backend/user/view', { params })
}

// 添加学员
export function addUser(data: { name: string; mobile: string; gender: string; certificate_number: string; label?: string }) {
  return httpRequest.post('/api/psp/backend-v2/user/create', data)
}

// 更新资料
export function updateUser(data: { id: string; name: string; mobile: string; certificate_number: string; label?: string }) {
  return httpRequest.post('/api/psp/backend/user/update', data)
}

// 获取星星记录列表
export function getStarRecordList(params: { id: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/user/star-record', { params })
}

// 获取签到记录列表
export function getSignInList(params: { id: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/user/sign-in-record', { params })
}

// 学员同步
export function syncUser() {
  return httpRequest.get('/api/psp/backend/user/sync')
}

// 导出学员列表
export function exportUser(params?: { name?: string; mobile?: string }) {
  return httpRequest.get('/api/psp/backend/user/download', { params, responseType: 'blob' })
}

// 学员关联课程时课程列表
export function getUserCourseList(params: { type: 'new' | 'old'; sso_id: string; category?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend-v2/user/courses', { params })
}

// 学员关联课程时课程列表
export function updateUserCourse(data: { sso_id: string; course_id: string; type: 'add' | 'delete' }) {
  return httpRequest.post('/api/psp/backend-v2/user/relation', data)
}
