import httpRequest from '@/utils/axios'

// 获取团队列表
export function getTeamList(params?: { name?: string; status?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/team/index', { params })
}

// 团队审核
export function submitAudit(data: { id: string; status: 0 | 1 }) {
  return httpRequest.post('/api/psp/backend/team/audit', data)
}

// 获取团队详情
export function getTeam(params: {
  id: string
  members_page?: number
  members_page_size?: number
  files_page?: number
  files_page_size?: number
  questions_page?: number
  questions_page_size?: number
}) {
  return httpRequest.get('/api/psp/backend/team/view', { params })
}

// 团队管理-团队文件或者问答删除
export function deleteFileOrQuestion(data: { id: string; type: 'question' | 'file' }) {
  return httpRequest.post('/api/psp/backend/team/file-or-question-delete', data)
}

// 团队管理-成员审核
export function submitMemberAudit(data: { team_id: string; user_id: string; status: '1' | '4' }) {
  return httpRequest.post('/api/psp/backend/team/member-audit', data)
}

// 团队管理-成员删除
export function deleteMember(data: { team_id: string; user_id: string }) {
  return httpRequest.post('/api/psp/backend/team/member-delete', data)
}
