import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/student',
    component: AppLayout,
    children: [
      { path: '', component: () => import('./views/List.vue') },
      { path: 'update/:id', component: () => import('./views/Update.vue'), props: true },
      { path: 'view/:id', component: () => import('./views/View.vue'), props: true }
    ]
  }
]
