import httpRequest from '@/utils/axios'

// 获取视频列表
export function getVideoList(params?: { type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/video/index', { params })
}

// 创建视频
export function createVideo(data: { course_name: string; cover_page: string; type: string; weight?: string }) {
  return httpRequest.post('/api/psp/backend/video/create', data)
}

// 更新视频
export function updateVideo(data: {
  id: string
  course_name: string
  cover_page: string
  type: string
  weight?: string
}) {
  return httpRequest.post('/api/psp/backend/video/update', data)
}

// 获取视频详情
export function getVideo(params: { id: string }) {
  return httpRequest.get('/api/psp/backend/video/view', { params })
}

// 删除视频
export function deleteVideo(data: { id: string }) {
  return httpRequest.post('/api/psp/backend/video/delete', data)
}
