import { defineStore } from 'pinia'
import { getUser, logout } from '@/api/base'

interface IUserState {
  id: string
  avatar: string
  mobile: string
  realname: string
  nickname: string
  username: string
  email: string
}

export const useUserStore = defineStore({
  id: 'user',
  state: () => {
    return {
      user: null as IUserState | null
    }
  },
  getters: {
    isLogin: state => !!state.user,
    userName: ({ user }) => {
      if (!user) return ''
      return user.realname || user.nickname || user.username || ''
    }
  },
  actions: {
    async getUser() {
      const res = await getUser()
      this.user = res.data
    },
    async logout() {
      await logout()
      this.user = null
    }
  }
})
