import httpRequest from '@/utils/axios'

// 获取资料消息列表
// 类型（1:入学指南，2：学习地图，3：考试攻略，4：消息）
export function getBannerList(params?: { type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/banner/index', { params })
}

// 创建资料
export function createBanner(data: { title: string; desc: string; type: string; weight?: string }) {
  return httpRequest.post('/api/psp/backend/banner/create', data)
}

// 更新资料
export function updateBanner(data: { id: string; title: string; desc: string; type: string; weight?: string }) {
  return httpRequest.post('/api/psp/backend/banner/update', data)
}

// 获取资料详情
export function getBanner(params: { id: string }) {
  return httpRequest.get('/api/psp/backend/banner/view', { params })
}

// 删除资料
export function deleteBanner(data: { id: string }) {
  return httpRequest.post('/api/psp/backend/banner/delete', data)
}
