import httpRequest from '@/utils/axios'

// 获取推荐课程列表
export function getCourseRecommendList(params?: { name?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/recommend-course/index', { params })
}

// 创建推荐课程
export function createCourseRecommend(data: { name: string; cover: string; weight?: string }) {
  return httpRequest.post('/api/psp/backend/recommend-course/create', data)
}

// 更新推荐课程
export function updateCourseRecommend(data: { id: string; name: string; cover: string; weight?: string }) {
  return httpRequest.post('/api/psp/backend/recommend-course/update', data)
}

// 获取推荐课程详情
export function getCourseRecommend(params: { id: string }) {
  return httpRequest.get('/api/psp/backend/recommend-course/view', { params })
}

// 删除推荐课程
export function deleteCourseRecommend(data: { id: string }) {
  return httpRequest.post('/api/psp/backend/recommend-course/delete', data)
}
