import httpRequest from '@/utils/axios'

// 获取问题列表
export function getQuestionList(params?: { name?: string; mobile?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/question/index', { params })
}

// 获取问题详情
export function getQuestion(params: { id: string; page_size?: number; page?: number }) {
  return httpRequest.get('/api/psp/backend/question/view', { params })
}

// 删除问题
export function deleteQuestion(data: { id: string }) {
  return httpRequest.post('/api/psp/backend/question/delete', data)
}
