import fs from 'fs'
import path from 'path'
import { fileURLToPath, URL } from 'url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import AutoImport from 'unplugin-auto-import/vite'

export default defineConfig(({ mode }) => {
  return {
    base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/admin-prp/' : '/',
    plugins: [
      vue({ reactivityTransform: true }),
      AutoImport({ imports: ['vue', 'vue/macros', 'vue-router'], dts: true, eslintrc: { enabled: true } })
    ],
    server: {
      open: true,
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.join(__dirname, './https/ezijing.com.key')),
        cert: fs.readFileSync(path.join(__dirname, './https/ezijing.com.pem'))
      },
      proxy: {
        '/api': 'https://psp-center.ezijing.com'
      }
    },
    resolve: {
      alias: {
        '@': fileURLToPath(new URL('./src', import.meta.url))
      }
    }
  }
})
