import httpRequest from '@/utils/axios'

/**
 * 获取应用列表
 */
export function getAppList(params) {
  return httpRequest.get('/api/register/v1/records/index', { params })
}
/**
 * 删除报名步骤
 */
export function deletePay(data) {
  return httpRequest.post('/api/register/v1/records/delete-pay', data)
}

/**
 * 删除报名记录
 */
export function deleteJoin(data) {
  return httpRequest.post('/api/register/v1/records/delete-join', data)
}

/**
 * 导入
 */
export function importPeople(data) {
  return httpRequest({
    url: '/api/register/v1/records/import',
    method: 'post',
    headers: { 'Content-Type': 'multipart/form-data' },
    timeout: 900000,
    data,
    withCredentials: true
  })
}

/**
 * 获取应用列表
 */
export function getActivityList() {
  return httpRequest.get('/api/register/v1/records/activity-list')
}

/**
 * 报名记录详情
 */
export function getRecordsDetail(params) {
  return httpRequest.get('/api/register/v1/records/view', { params })
}

/**
 * 报名记录-缴费弹窗
 */
export function getPayList(params) {
  return httpRequest.get('/api/register/v1/records/pay-list', { params })
}

/**
 * 获取二维码
 */
export function recordsQr(data) {
  return httpRequest.post('/api/register/v1/records/qr', data)
}

/**
 * 保存报名记录信息
 */
export function updateRecords(data) {
  return httpRequest.post('/api/register/v1/records/update', data)
}
