import store from '@/store'

const UA = navigator.userAgent
const isMobile = /iphone/i.test(UA) || (/android/i.test(UA) && /mobile/i.test(UA))
const isIe = window.ActiveXObject || 'ActiveXObject' in window
// const isChrome = !!window.chrome && (!!window.chrome.webstore || !!window.chrome.runtime)
// let chromeVersion = 0
// if (isChrome) {
//   const temp = UA.match(/Chrome\/([\d.]+)/)
//   chromeVersion = temp ? parseFloat(temp[1]) : 0
// }
// const notSupport = !isMobile && (isIe || (isChrome && chromeVersion < 70))
const notSupport = !isMobile && isIe
// https://stackoverflow.com/questions/9847580/how-to-detect-safari-chrome-ie-firefox-and-opera-browser

export default async function (to, from, next) {
  // 浏览器不支持
  if (notSupport && to.name !== 'browser') {
    next({ path: '/browser' })
    return
  }
  // 登录白名单
  const whiteList = []
  if (whiteList.includes(to.path)) {
    next()
    return
  }
  const isLogin = store.state.user.id || (await store.dispatch('checkLogin'))
  if (!isLogin) {
    window.location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(window.location.href)}`
    return
  }

  next()
}
