import httpRequest from '@/utils/axios'

/**
 * 获取班级列表
 */
export function getClassList() {
  return httpRequest.get('/api/register/v1/activity/class-list')
}
/**
 * 获取课程列表
 */
export function getCourseList(params) {
  return httpRequest.get('/api/register/v1/activity/course-list', { params })
}
/**
 * 获取应用列表
 */
export function getAppList(params) {
  return httpRequest.get('/api/register/v1/activity/index', { params })
}
/**
 * 新建报名
 */
export function createRegister(data) {
  return httpRequest.post('/api/register/v1/activity/create', data)
}

/**
 * 报名详情
 */
export function getRegisterDetail(params) {
  return httpRequest.get('/api/register/v1/activity/view', { params })
}

/**
 * 更新报名
 */
export function updateRegister(data) {
  return httpRequest.post('/api/register/v1/activity/update', data)
}

/**
 * 删除报名
 */
export function deleteRegister(data) {
  return httpRequest.post('/api/register/v1/activity/delete', data)
}
/**
 * 停止活动
 */
export function stopRegister(data) {
  return httpRequest.post('/api/register/v1/activity/drop', data)
}
