import httpRequest from '@/utils/axios'

// 获取教案列表
export function getLessonList(params?: {
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  ['per-page']?: number
}) {
  return httpRequest.get('/api/resource/v1/resource/lesson-plan/list', { params })
}

// 创建教案
export function createLessonPlan(data: { name: string; source: string; classification: string; knowledge_points: string; url: string; type: string; size: string }) {
  return httpRequest.post('/api/resource/v1/resource/lesson-plan/create', data)
}
