import httpRequest from '@/utils/axios'

// 获取专业列表
export function getProList(params?: { name?: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/backend/specialty/list', { params })
}
// 创建专业
export function createPro(data: {
  name: string
  code: string
  education_background: string
  length_of_schooling: string
  degree_category: string
  degree: string
}) {
  return httpRequest.post('/api/resource/v1/backend/specialty/create', data)
}
// 更新专业
export function updatePro(data: {
  id: string
  name: string
  code: string
  education_background: string
  length_of_schooling: string
  degree_category: string
  degree: string
}) {
  return httpRequest.post('/api/resource/v1/backend/specialty/update', data)
}
// 获取专业详情
export function getProDetail(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/specialty/view', { params })
}
