import httpRequest from '@/utils/axios'

// 获取其他资料列表
export function getOtherList(params?: {
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  ['per-page']?: number
}) {
  return httpRequest.get('/api/resource/v1/resource/other-information/list', { params })
}
// 获取其他资料详情
export function getOtherDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/other-information/view', { params })
}

// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/other-information/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/other-information/set-platform', data)
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/other-information/set-status', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/resource/other-information/set-belong', data)
}
