import type { Router, RouteRecordRaw } from 'vue-router'

export default function ({ router }: { router: Router }) {
  const modules: Array<{ routes: Array<RouteRecordRaw> }> = Object.values(import.meta.globEager('./**/index.ts'))
  modules.forEach(({ routes = [] }) => {
    // 注册路由
    routes.forEach(route => {
      router.addRoute(route)
    })
  })
}
