import httpRequest from '@/utils/axios'

// 获取封面列表
export function getCoverList(params?: { type?: string; page?: number; ['per-page']?: number }) {
  return httpRequest.get('/api/resource/v1/backend/cover/list', { params })
}
// 创建封面
export function createCover(data?: { title?: string; status?: string; type?: string; url?: string }) {
  return httpRequest.post('/api/resource/v1/backend/cover/create', data)
}
// 更新封面
export function updateCover(data?: { id: any; title?: string; status?: string; type?: string; url?: string }) {
  return httpRequest.post('/api/resource/v1/backend/cover/update', data)
}
// 删除封面
export function deleteCover(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/cover/delete', data)
}
