import httpRequest from '@/utils/axios'

// 获取视频列表
export function getVideoList(params: {
  course_id: string
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-video', { params })
}

// 获取视频详情
export function getVideoDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/video/view', { params })
}


// 获取课程列表
export function getCourseList(params: {
  tab: string
  name?: string
  authorized?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/list', { params })
}
// 获取课件列表
export function getCourseListSearch(params: {
  tab: string
  name?: string
  authorized?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-courseware', { params })
}

// 获取课程统计
export function getCourseStatistics() {
  return httpRequest.get('/api/resource/v1/course/course/statistics')
}

// 获取章节
export function getCharacter(params: { course_id: string; type: string }) {
  return httpRequest.get('/api/resource/v1/course/course/chapters', { params })
}

// 获取课程详情
export function getViewCourseDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/course/course/view', { params })
}

// 获取教案详情
export function getLessonDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/lesson-plan/view', { params })
}

// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-platform', data)
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-status', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-belong', data)
}

// 课程授权
export function courseAuthorization(data: { id: string; organ_ids: string }) {
  return httpRequest.post('/api/resource/v1/course/course/authorization', data)
}

// 复制课程
export function courseCopy(data: { id: string; }) {
  return httpRequest.post('/api/resource/v1/course/course/copy', data)
}
